/*
 * Decompiled with CFR 0.152.
 */
package com.zarafa.jsconcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Concatinator {
    private static final Pattern classPattern = Pattern.compile("\\W+@class\\s+(.+)");
    private static final Pattern extendsPattern = Pattern.compile("\\W+@extends\\s+(.+)");
    private static final Pattern dependsPattern = Pattern.compile("\\W+#dependsFile\\s+(.+)");
    private HashMap<String, FileNode> classDefs;
    private HashMap<String, String> classExtends;
    private ArrayList<FileNode> fileNodes = new ArrayList();

    public Concatinator() {
        this.classDefs = new HashMap();
        this.classExtends = new HashMap();
    }

    public void addFile(String fileName) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        FileNode node = new FileNode(file);
        node.analyse();
        this.fileNodes.add(node);
    }

    public void sort(String prioritise) {
        if (prioritise == null) {
            throw new NullPointerException();
        }
        for (FileNode fileNode : this.fileNodes) {
            for (String className : fileNode.classNames) {
                String parentClass = this.classExtends.get(className);
                if (!this.classDefs.containsKey(parentClass)) continue;
                fileNode.addDependency(this.classDefs.get(parentClass));
            }
            for (String dependencyName : fileNode.dependencyNames) {
                for (FileNode depNode : this.fileNodes) {
                    if (!depNode.file.getAbsolutePath().endsWith(dependencyName)) continue;
                    fileNode.addDependency(depNode);
                }
            }
        }
        for (FileNode fileNode : this.fileNodes) {
            fileNode.depth = fileNode.dependNodes.size() == 0 ? 0 : -1;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (FileNode fileNode : this.fileNodes) {
                int max = -1;
                boolean complete = true;
                for (FileNode dependency : fileNode.dependNodes) {
                    complete = complete && dependency.depth != -1;
                    max = Math.max(max, dependency.depth);
                }
                if (!complete || fileNode.depth == max + 1) continue;
                fileNode.depth = max + 1;
                changed = true;
            }
        }
        String[] stringArray = prioritise.trim().split(",\\s*");
        block8: for (FileNode fileNode : this.fileNodes) {
            fileNode.priority = stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!fileNode.matchClassNames(stringArray[i])) continue;
                fileNode.priority = i;
                continue block8;
            }
        }
        Collections.sort(this.fileNodes, new Comparator<FileNode>(){

            @Override
            public int compare(FileNode node1, FileNode node2) {
                if (node1.depth == node2.depth) {
                    if (node1.priority < node2.priority) {
                        return -1;
                    }
                    if (node1.priority == node2.priority) {
                        return 0;
                    }
                    return 1;
                }
                if (node1.depth < node2.depth) {
                    return -1;
                }
                if (node1.depth > node2.depth) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void printStatus() {
        System.out.printf("%-40s %-6s %-8s %s\n", "File", "Depth", "Priority", "Dependencies");
        System.out.println("----------------------------------------------------------------------");
        for (FileNode fileNode : this.fileNodes) {
            String deps = fileNode.dependNodes.toString();
            System.out.printf("%-40s %-6d %-8d %s%n", fileNode, fileNode.depth, fileNode.priority, deps.substring(1, deps.length() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concat(String outputFileName) throws FileNotFoundException, IOException {
        FileOutputStream outStream = new FileOutputStream(outputFileName);
        ArrayList<FileInputStream> inputStreams = new ArrayList<FileInputStream>();
        for (FileNode fileNode : this.fileNodes) {
            inputStreams.add(new FileInputStream(fileNode.file));
        }
        SequenceInputStream input = new SequenceInputStream(Collections.enumeration(inputStreams));
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = input.read(buf)) != -1) {
                outStream.write(buf, 0, len);
            }
        }
        finally {
            input.close();
            outStream.close();
        }
    }

    private class FileNode {
        public File file;
        public int depth;
        public int priority;
        public Vector<String> classNames;
        public Vector<String> dependencyNames;
        public Vector<FileNode> dependNodes;

        public FileNode(File file) {
            this.file = file;
            this.classNames = new Vector();
            this.dependencyNames = new Vector();
            this.dependNodes = new Vector();
        }

        public void analyse() throws FileNotFoundException, IOException {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String className = null;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = classPattern.matcher(line);
                if (matcher.matches()) {
                    className = matcher.group(1);
                    Concatinator.this.classDefs.put(className, this);
                    this.classNames.add(className);
                }
                if ((matcher = extendsPattern.matcher(line)).matches() && className != null) {
                    Concatinator.this.classExtends.put(className, matcher.group(1));
                }
                if (!(matcher = dependsPattern.matcher(line)).matches()) continue;
                this.dependencyNames.add(matcher.group(1).replace('/', File.separatorChar));
            }
            reader.close();
        }

        public boolean matchClassNames(String expression) {
            for (String className : this.classNames) {
                if (!className.matches(expression)) continue;
                return true;
            }
            return false;
        }

        public void addDependency(FileNode node) {
            if (this != node) {
                this.dependNodes.add(node);
            }
        }

        public String toString() {
            return this.file.getName();
        }
    }
}

