/*
 * Decompiled with CFR 0.152.
 */
package com.zarafa.jsconcat;

import com.zarafa.jsconcat.Concatinator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class JsConcatTask
extends Task {
    private ArrayList<FileSet> fileSets = new ArrayList();
    private ArrayList<FileList> fileLists = new ArrayList();
    private String destFile;
    private String prioritise = "";
    private boolean verbose = false;

    public List<String> collectFileNames() {
        File dir;
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileSet fileSet : this.fileSets) {
            dir = fileSet.getDir(this.getProject());
            for (String fileName : fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                fileNames.add(dir + "/" + fileName);
            }
        }
        for (FileList fileList : this.fileLists) {
            dir = fileList.getDir(this.getProject());
            for (String fileName : fileList.getFiles(this.getProject())) {
                fileNames.add(dir + "/" + fileName);
            }
        }
        return fileNames;
    }

    public boolean checkFiles(List<String> fileNames) {
        File file = new File(this.destFile);
        if (!file.exists()) {
            return true;
        }
        long destLastModified = file.lastModified();
        for (String fileName : fileNames) {
            file = new File(fileName);
            if (!file.exists() || file.lastModified() <= destLastModified) continue;
            return true;
        }
        return false;
    }

    public void execute() {
        if (this.destFile == null || this.destFile.equals("")) {
            throw new BuildException("'destfile' property not set.");
        }
        List<String> files = this.collectFileNames();
        if (!this.checkFiles(files)) {
            this.log("Files are up to date");
            return;
        }
        Concatinator concat = new Concatinator();
        try {
            for (String fileName : files) {
                concat.addFile(fileName);
            }
            concat.sort(this.prioritise);
            if (this.verbose) {
                concat.printStatus();
            }
            concat.concat(this.destFile);
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println("Generic IO exception: " + ex.getMessage());
        }
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.fileLists.add(fileList);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    public void setPrioritize(String prioritise) {
        this.prioritise = prioritise;
    }

    public void setPrioritise(String prioritise) {
        this.prioritise = prioritise;
    }
}

