<?php
/**
* Handles plugin registration.
*/
class PluginMDM extends Plugin {

	/**
	 * Called to initialize the plugin and register for hooks.
	 */
	function init(){
		$this->registerHook('server.core.settings.init.before');

		// This hook is used to add the Z-Push server version to the settings
		$this->registerHook('server.index.load.main.before');
	}

	/**
	 * Function is executed when a hook is triggered by the PluginManager
	 * @param String $eventID Identifier of the hook
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function execute($eventID, &$data){
		switch($eventID){
			case 'server.core.settings.init.before':
				$this->onBeforeSettingsInit($data);
				break;
			case 'server.index.load.main.before':
				$this->addZPushVersionToSettings();
				break;
		}
	}

	/**
	 * Called when the core Settings class is initialized and ready to accept sysadmin default
	 * settings. Registers the sysadmin defaults for the StatsLogging plugin.
	 * @param Array $data Reference to the data of the triggered hook
	 */
	function onBeforeSettingsInit(&$data){
		$data['settingsObj']->addSysAdminDefaults(Array(
			'zarafa' => Array(
				'v1' => Array(
					'plugins' => Array(
						'mdm' => Array(
							'enable' => PLUGIN_MDM_USER_DEFAULT_ENABLE_MDM,
						)
					)
				)
			)
		));
	}

	/**
	 * Helper function to version of the z-push server to the MDM settings.
	 * This function will call setZpushServerVersion function of pluginmdmmodule class
	 * which will set version info.
	 */
	function addZPushVersionToSettings(){
		// This is a bit ugly, but since all z-push logic was put in the MDM module class,
		// we have added the getServerVersion function there also
		require_once(BASE_PATH . 'server/includes/modules/class.module.php');
		require_once('class.pluginmdmmodule.php');

		$module = new PluginMDMModule('fakeid', array());
		$module->setZpushServerVersion();
	}
}
?>